<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Carrer extends Model 
{

    protected $table = 'careers';
    public $timestamps = true;
    protected $fillable = array('job_id', 'name', 'email', 'address');

    public function job()
    {
        return $this->belongsTo('App\Models\Job');
    }

    public function photo()
    {
        return $this->morphOne('App\Models\Photo', 'photoable');
    }

}